#version 300 es

precision mediump float;


in vec2 vTexCoord;
uniform sampler2D rainBitmap;
uniform sampler2D dropsBitmap;
uniform sampler2D backBitmap;
uniform sampler2D lightBitmap;

uniform float uRainReflectScale;
uniform float uDrizzleReflectScale;
uniform float uDrizzleEdge;
uniform float uRainEdge;

out vec4 FragColor;

void main()
{
	vec4 drops = texture(dropsBitmap, vTexCoord );
	vec4 rain = texture(rainBitmap, vTexCoord );

	vec2 rainReflect1 = vTexCoord + (rain.xy - 0.5) * uDrizzleReflectScale;
	vec2 rainReflect2 = vTexCoord + ( drops.xy - 0.5) * uRainReflectScale;

	vec2 coord1 = mix(rainReflect1, vTexCoord, clamp(rain.b * uDrizzleEdge , 0.0, 1.0) );
	vec2 coord2 = mix(rainReflect2, coord1, clamp((1.0- drops.a*1.1) * uRainEdge, 0.0, 1.0) );

	FragColor = texture(backBitmap, coord2);
	vec4 dropShapes = texture(lightBitmap, drops.xy);
	FragColor.rgb = mix(FragColor.rgb, dropShapes.rgb, dropShapes.a);
	vec2 test = mix(rainReflect2, vTexCoord, clamp((1.0- drops.a) * uRainEdge, 0.0, 1.0) );
	//FragColor = drops;
}
